<?php

header('Content-Type: text/html; charset=utf-8');



function utf8_str_split($str='',$len=1){

    preg_match_all("/./u", $str, $arr);

    $arr = array_chunk($arr[0], $len);

    $arr = array_map('implode', $arr);

    return $arr;

}



############################################################ SAVE OWNER ################################################################

if(isset($_POST['save_passport'],$_POST['save_passport_id'],$_POST['save_passport_signature']))

{

	require_once '../config.php';

	

	$save_passport = array();

	parse_str($_POST['save_passport'], $save_passport);

	$_POST['save_passport'] = serialize($save_passport);

	

	if($_POST['save_passport_id'] == 1)

	{

		try

		{

			$q = $pdo->prepare("INSERT INTO owners (owner,owner_default) VALUES (?,?)");

			$q ->bindValue(1,$_POST['save_passport']);

			$q ->bindValue(2,$save_passport['owner_default']);

			$q ->execute();

		}

		catch (PDOException $e) {echo 'Error !'; exit();}

		$_SESSION['success'] = 'Owner added !';

		$_SESSION['save_passport_id'] = $pdo->lastInsertId();

	}

	else

	{

		try

		{

			$q = $pdo->prepare("UPDATE owners SET owner = ?, owner_default = ? WHERE owner_id = ?");

			$q ->bindValue(1,$_POST['save_passport']);

			$q ->bindValue(2,$save_passport['owner_default']);

			$q ->bindValue(3,$_POST['save_passport_id']);

			$q ->execute();

		}

		catch (PDOException $e) {echo 'Error !'; exit();}

		$_SESSION['save_passport_id'] = $_POST['save_passport_id'];

		$_SESSION['success'] = 'Owner saved !';

	}

	

	file_put_contents('../t/'.$_SESSION['save_passport_id'].'_signature.png', base64_decode($_POST['save_passport_signature']));



	echo 'done'; exit();

}

elseif(isset($_POST['save_passport_image_1']) || isset($_POST['save_passport_image_2']) || isset($_POST['save_passport_image_3']))

{

	session_start();

	if(isset($_POST['save_passport_image_1']))

	{

		$_SESSION['passport'] = $_POST['save_passport_image_1'];

	}

	elseif(isset($_POST['save_passport_image_2']))

	{

		$_SESSION['passport'] .= $_POST['save_passport_image_2']; 

	}

	elseif(isset($_POST['save_passport_image_3']))

	{

		$_SESSION['passport'] .= $_POST['save_passport_image_3'];

		

		$save_passport_image = '../t/'.$_SESSION['save_passport_id'].'.png';

		file_put_contents($save_passport_image, base64_decode($_SESSION['passport']));



		if($_POST['save_passport_quality'] > 0)

		{

			$passport = imagecreatefrompng($save_passport_image); 

			imagesavealpha($passport, true);

			$i = 0;

			while ($i++ < $_POST['save_passport_quality'])

			{

				imagefilter($passport, IMG_FILTER_GAUSSIAN_BLUR);

			}

			imagepng($passport, $save_passport_image);

		}

	}

	echo 'done'; exit();

}

unset($_SESSION['save_passport_id']);



######################################################### DELETE OWNER #################################################################

if(@$_GET['do'] == 'delete')

{

	$_GET['id'] = substr($_GET['id'],0,-1);

	$_GET['id'] = explode(',',$_GET['id']);

	

	foreach($_GET['id'] as $id)

	{

		try

		{

			$q = $pdo->prepare("SELECT property_detail_owner FROM properties WHERE property_detail_owner = $id");

			$q ->execute();

		}

		catch (PDOException $e) {echo 'Error !'; exit();}

		if($q->rowCount() > 0)

		{

			$_SESSION['error'] = "One or more owners can't be deleted because are selected for some properties!";

		}

		else

		{

			try

			{

				$q = $pdo->prepare("DELETE FROM owners WHERE owner_id = $id");

				$q ->execute();

			}

			catch (PDOException $e) {echo 'Error !'; exit();}

			if($q->rowCount() == 0)

			{

				$_SESSION['error'] = 'There was an error. Please try again or contact webmaster !';

			}

			elseif($q->rowCount() == 1)

			{

				$_SESSION['success'] = 'The selected owners have been deleted.';

				if(file_exists('../t/'.$id.'.png')) { unlink('../t/'.$id.'.png'); }

				if(file_exists('../t/'.$id.'_signature.png')) { unlink('../t/'.$id.'_signature.png'); }

			}

		}

	}

	r('p=owners');

}



############################################################ SHOW OWNER ################################################################

if(isset($_GET['default_owners']))

{

	if($_SESSION['default_owners'] == '0')

	{

		$_SESSION['default_owners'] = '0,1';

	}

	else

	{

		$_SESSION['default_owners'] = '0';

	}

	header('Location: ?p=owners'); exit();

}



try

{

	$q = $pdo->prepare("SELECT * FROM owners WHERE owner_default IN (".$_SESSION['default_owners'].") ORDER by owner_id");

	$q ->execute();

}

catch (PDOException $e) {echo 'Error !'; exit();}

echo '<div id="owners">';

	if($q->rowCount() < 2)

	{

		echo '<p class="center p10">';

			echo 'No owner found ! ';

			echo 'Do you want to add an owner ?<br /><br />';

			echo '<a class="button r3" href="#">Add owner</a> OR ';

			echo '<a class="button r3" href="?p=owners&default_owners">Show default owners</a>';

		echo '</p>';

	}

	else

	{

		echo '<form action="" method="post">';

			echo '<button class="select r3">Select all</button>';

			echo '<button class="deselect r3">Deselect all</button>';

			echo '<button class="delete opacity r3">Delete selected</button>';

			echo '<a class="default r3" href="?p=owners&default_owners"';

			if($_SESSION['default_owners'] != '0') { echo ' style="background:#ebffe5"';}

			echo '>Default owners</a>';

			echo '<a class="add fright r3" href="#">Add owner</a>';

			echo '<input type="text" class="search fright r3" '.value('Search owner...').' />';

					

			echo '<div class="confirmation r6">';

				echo '<p><img src="f/error.png" />Are you sure you want to delete de folowing owners ?</p>';

				echo '<br /><p></p><br />';

				echo '<a href="#" onclick="'."$('.confirmation').slideUp(); return false;".'" class="r3">'."No, I'm not sure".'</a>';

				echo '<a href="#" onclick="'."$('#p').show()".'" class="r3 danger">'."Yes, I'm sure".'</a>';

			echo '</div>';

		echo '</form>';	

	}

	

	echo '<div class="after"></div>';

	

	while($owner = $q->fetch(PDO::FETCH_ASSOC))

	{

		$owner_fields = unserialize($owner['owner']);

		echo '<label class="no-select'; if(!isset($first)) {echo ' label_example';} echo '">';

		echo '<input type="checkbox" value="'.$owner['owner_id'].'" />';

		

		try

		{

			$property = $pdo->prepare("SELECT property_name FROM properties WHERE property_detail_owner = ".$owner['owner_id']);

			$property ->execute();

		}

		catch (PDOException $e) {echo 'Error !'.$e; exit();}

		$count_properties = $property->rowCount();

		

		echo '<span class="name">'.@$owner_fields['passport_first_name'].' '.@$owner_fields['passport_last_name'].'</span>';

		$i = 0;

		echo '<b>'.$count_properties.'</b>'; if($count_properties > 0) {echo ': ';}

		while($property_name = $property->fetch(PDO::FETCH_ASSOC))

		{

			$i++;

			if($i > 1) {echo ', ';} echo '<span>'.@$property_name['property_name'].'</span>';

		}

		unset($i);

		echo '<a href="/t/'.$owner['owner_id'].'.png" target="_blank" class="view r3">View passport</a>';

		echo '<a href="#" class="edit r3">Edit owner</a>';

		echo '</label>';

		echo '<table cellspacing="0" cellpadding="0" id="passport">';

			echo '<tr>';

				echo '<td valign="top">';

					$col_1_fields = array('passport_image','passport_code','passport_salutation','passport_first_name','passport_last_name','passport_date_of_birth','passport_city','passport_height','passport_eyes_color','passport_street','passport_bottom_code');

					foreach($col_1_fields as $field)

					{

						echo '<p>'.ucfirst(str_replace('_',' ',str_replace('passport_','',$field)));

						if($field == 'passport_image')

						{

							echo '<select name="passport_image">';

								echo '<option value="1"'; if(@$owner_fields[$field] == 1) { echo ' selected="selected"'; } echo '>Image 1</option>';

								echo '<option value="2"'; if(@$owner_fields[$field] == 2) { echo ' selected="selected"'; } echo '>Image 2</option>';

								echo '<option value="3"'; if(@$owner_fields[$field] == 3) { echo ' selected="selected"'; } echo '>Image 3</option>';

								echo '<option value="4"'; if(@$owner_fields[$field] == 4) { echo ' selected="selected"'; } echo '>Image 4</option>';

							echo '</select>';

						}

						elseif($field == 'passport_salutation')

						{

							echo '<select name="passport_salutation">';

								echo '<option value="Mrs."'; if(@$owner_fields[$field] == 'Mrs.') { echo ' selected="selected"'; } echo '>Mrs.</option>';

								echo '<option value="Mr."'; if(@$owner_fields[$field] == 'Mr.') { echo ' selected="selected"'; } echo '>Mr.</option>';

							echo '</select>';

						}

						else

						{

							echo ':<input type="text" name="'.$field.'" value="'.@$owner_fields[$field].'" />';

						}

						echo '</p>';

					}

				echo '</td>';

				echo '<td valign="top">';

					$col_2_fields = array('passport_signature','passport_signature_font','passport_signature_size','passport_signature_left','passport_signature_top','passport_signature_rotation','passport_autority','passport_expiration_date','passport_quality','passport_rotation','owner_default');

					foreach($col_2_fields as $field)

					{

						echo '<p>'.ucfirst(str_replace('_',' ',str_replace('passport_','',$field)));

						if($field == 'passport_signature_font')

						{

							$i = 0;

							echo '<select name="passport_signature_font">';

							foreach (new DirectoryIterator('f/fonts/') as $fileInfo)

							{

								if(!$fileInfo->isDot() || $fileInfo->isFile())

								{

									$i++; if($i < 10) {$i = '0'.$i;}

									echo '<option value="'.$i.'" font="'.$fileInfo->getFilename().'"';

									if($i == @$owner_fields['passport_signature_font']) { echo ' selected="selected"';}

									echo '>';

									echo $i.'. '.ucfirst(str_replace('_',' ',str_replace('.ttf','',str_replace('.otf','',$fileInfo->getFilename()))));

									echo '</option>';

								}

							}

							echo '</select>';

						}

						elseif($field == 'owner_default')

						{

							echo '<select name="owner_default">';

								echo '<option value="0"'; if(@$owner_fields[$field] == '0') { echo ' selected="selected"'; } echo '>No</option>';

								echo '<option value="1"'; if(@$owner_fields[$field] == '1') { echo ' selected="selected"'; } echo '>Yes</option>';

							echo '</select>';

						}

						elseif($field == 'passport_signature_size' || $field == 'passport_signature_left' || $field == 'passport_signature_top' || $field == 'passport_signature_rotation' || $field == 'passport_rotation')

						{

							echo '<span> px</span><input type="text" name="'.$field.'" class="min" value="'.@$owner_fields[$field].'" />';

						}

						else

						{

							echo '<input type="text" name="'.$field.'" value="'.@$owner_fields[$field].'" />';

						}

						echo '</p>';

					}

					echo '<input type="hidden" name="passport_id" value="'.$owner['owner_id'].'" />';

					echo '<button action="true">';

					if(!isset($first)) {echo 'Add';} else {echo 'Save';} $first = 'done';

					echo '</button>';

				echo '</td>';

			echo '</tr>';

		echo '</table>';

		echo '<div id="printscreen">';

			echo '<div style="background:#fff url(f/passport1.png) no-repeat center top;">';

				echo '<p class="passport_code_top"></p>';

				echo '<p class="passport_first_name"></p>';

				echo '<p class="passport_last_name"></p>';

				echo '<p class="passport_date_of_birth"></p>';

				echo '<p class="passport_city_top"></p>';

				echo '<p class="passport_country"><span>D</span><span>E</span><span>U</span><span>T</span><span>S</span><span>C</span><span>H</span></p>';

				echo '<p class="passport_expiration_date"></p>';

				echo '<p class="passport_signature"></p>';

				echo '<p class="passport_name_top"></p>';

				echo '<p class="passport_bottom_code"></p>';

				echo '<p class="passport_city_bottom bottom"></p>';

				echo '<p class="passport_street bottom"></p>';

				echo '<p class="passport_height bottom"></p>';

				echo '<p class="passport_height_cm bottom"><span>c</span><span>m</span></p>';

				echo '<p class="passport_eyes_color bottom"></p>';

				echo '<p class="passport_autority bottom"></p>';

				echo '<p class="passport_creation bottom"></p>';

				echo '<p class="passport_name_bottom bottom"></p>';

				echo '<p class="passport_code_bottom bottom"></p>';

			echo '</div>';

		echo '</div>';

	}

echo '</div>';

echo '<p class="passport_signature_print"></p>';

?>

<script>

function update(passport,printscreen)

{

	/*** PASSPORT IMAGE ***/

	$(printscreen).find('div').css('background','#fff url(f/passport' + $(passport).find('[name=passport_image]').find('option:selected').val() + '.png) no-repeat center top')

	

	/*** PASSPORT CODE TOP ***/

	$(printscreen).find('p.passport_code_top').text('');

	var passport_code_top = $(passport).find('[name=passport_code]').val();

	var passport_code_top_length = $(passport).find('[name=passport_code]').val().length;

	for (var i = 0; i < passport_code_top_length; i++) {

		$(printscreen).find('p.passport_code_top').append('<span>' + passport_code_top[i]  + '</span>');

	}

	

	/*** PASSPORT FIRST NAME & LAST NAME ***/

	$(printscreen).find('p.passport_name_top').html('<span>I</span><span>D</span><span>D</span><span class="break"><</span><span class="break"><</span>');

	var passport_first_name = $(passport).find('[name=passport_first_name]').val();

	var passport_first_name_length = $(passport).find('[name=passport_first_name]').val().length;

	var passport_last_name = $(passport).find('[name=passport_last_name]').val();

	var passport_last_name_length = $(passport).find('[name=passport_last_name]').val().length;

	for (var i = 0; i < passport_first_name_length; i++) {

		if(passport_first_name[i] == ' ')

		{

			$(printscreen).find('p.passport_name_top').append('<span class="break"><</span><span class="break"><</span>');

		}

		else

		{

			$(printscreen).find('p.passport_name_top').append('<span>' + passport_first_name[i]  + '</span>');

		}

	}

	$(printscreen).find('p.passport_name_top').append('<span class="break"><</span><span class="break"><</span>');

	for (var i = 0; i < passport_last_name_length; i++) {

		if(passport_last_name[i] == ' ')

		{

			$(printscreen).find('p.passport_name_top').append('<span class="break"><</span>');

		}

		else

		{

			$(printscreen).find('p.passport_name_top').append('<span>' + passport_last_name[i]  + '</span>');

		}

	}

	var name_length = $(printscreen).find('p.passport_name_top:first').text().length;

	for (var i = 0; i < (36 - name_length); i++) {

		$(printscreen).find('p.passport_name_top').append('<span class="break"><</span>');

	}

	$(printscreen).find('p.passport_first_name').text('');

	for (var i = 0; i < passport_first_name_length; i++) {

		$(printscreen).find('p.passport_first_name').append('<span>' + passport_first_name[i]  + '</span>');

	}

	$(printscreen).find('p.passport_last_name').text('');

	for (var i = 0; i < passport_last_name_length; i++) {

		$(printscreen).find('p.passport_last_name').append('<span>' + passport_last_name[i]  + '</span>');

	}

	

	/*** PASSPORT DATE OF BIRTH ***/

	$(printscreen).find('p.passport_date_of_birth').text('');

	var passport_date_of_birth = $(passport).find('[name=passport_date_of_birth]').val();

	var passport_date_of_birth_length = $(passport).find('[name=passport_date_of_birth]').val().length;

	for (var i = 0; i < passport_date_of_birth_length; i++) {

		$(printscreen).find('p.passport_date_of_birth').append('<span>' + passport_date_of_birth[i]  + '</span>');

	}

	

	/*** PASSPORT CITY TOP ***/

	$(printscreen).find('p.passport_city_top').text('');

	var passport_city_top = $(passport).find('[name=passport_city]').val();

	var passport_city_top_length = $(passport).find('[name=passport_city]').val().length;

	for (var i = 0; i < passport_city_top_length; i++) {

		$(printscreen).find('p.passport_city_top').append('<span>' + passport_city_top[i]  + '</span>');

	}

	

	/*** PASSPORT EXPIRATION DATE ***/

	$(printscreen).find('p.passport_expiration_date').text('');

	var passport_expiration_date = $(passport).find('[name=passport_expiration_date]').val();

	var passport_expiration_date_length = $(passport).find('[name=passport_expiration_date]').val().length;

	for (var i = 0; i < passport_expiration_date_length; i++) {

		$(printscreen).find('p.passport_expiration_date').append('<span>' + passport_expiration_date[i]  + '</span>');

	}

	

	/*** PASSPORT SIGNATURE ***/

	$(printscreen).find('p.passport_signature').text('');

	var passport_signature = $(passport).find('[name=passport_signature]').val();

	var passport_signature_length = $(passport).find('[name=passport_signature]').val().length;

	for (var i = 0; i < passport_signature_length; i++) {

		if(passport_signature[i] == ' ')

		{

			$(printscreen).find('p.passport_signature').append('<span class="break"></span>');

		}

		else

		{

			$(printscreen).find('p.passport_signature').append(passport_signature[i]);

		}

	}

	var passport_signature_font = $(passport).find('[name=passport_signature_font] option:selected').val();

	var passport_signature_size = parseInt($(passport).find('[name=passport_signature_size]').val());

	var passport_signature_left = $(passport).find('[name=passport_signature_left]').val();

	var passport_signature_top = $(passport).find('[name=passport_signature_top]').val();

	var passport_signature_rotation = $(passport).find('[name=passport_signature_rotation]').val();

	$(printscreen).find('p.passport_signature').css('font-family','font' + passport_signature_font).css('font-size',passport_signature_size + 'px').css('left',passport_signature_left + 'px').css('top',passport_signature_top + 'px');

	$(printscreen).find('p.passport_signature').jqrotate(passport_signature_rotation);

	

	/*** PASSPORT SIGNATURE AGREEMENT ***/

	$('body').find('p.passport_signature_print').css('font-family','font' + passport_signature_font).css('font-size',(passport_signature_size*1.3) + 'px').css('left','').css('top','').html($(printscreen).find('p.passport_signature').html()).jqrotate(2);

	

	/*** PASSPORT BOTTOM CODE ***/

	$(printscreen).find('p.passport_bottom_code').text('');

	var passport_bottom_code = $(passport).find('[name=passport_code]').val() + $(passport).find('[name=passport_bottom_code]').val();

	var passport_bottom_code_length = passport_bottom_code.length;

	for (var i = 0; i < passport_bottom_code_length; i++) {

		if(passport_bottom_code[i] == '<')

		{

			$(printscreen).find('p.passport_bottom_code').append('<span class="break"><</span>');

		}

		else

		{

			$(printscreen).find('p.passport_bottom_code').append('<span>' + passport_bottom_code[i]  + '</span>');

		}

	}

	

	/*** PASSPORT CITY BOTTOM ***/

	$(printscreen).find('p.passport_city_bottom').text('');

	var passport_city_bottom = $(passport).find('[name=passport_city]').val();

	var passport_city_bottom_length = passport_city_bottom.length;

	for (var i = 0; i < passport_city_bottom_length; i++) {

		$(printscreen).find('p.passport_city_bottom').append('<span>' + passport_city_bottom[i]  + '</span>');

	}

	

	/*** PASSPORT STREET ***/

	$(printscreen).find('p.passport_street').text('');

	var passport_street = $(passport).find('[name=passport_street]').val();

	var passport_street_length = passport_street.length;

	for (var i = 0; i < passport_street_length; i++) {

		$(printscreen).find('p.passport_street').append('<span>' + passport_street[i]  + '</span>');

	}

	

	/*** PASSPORT STREET ***/

	$(printscreen).find('p.passport_height').text('');

	var passport_height = $(passport).find('[name=passport_height]').val();

	var passport_height_length = passport_height.length;

	for (var i = 0; i < passport_height_length; i++) {

		$(printscreen).find('p.passport_height').append('<span>' + passport_height[i]  + '</span>');

	}

	

	/*** PASSPORT EYES COLOR ***/

	$(printscreen).find('p.passport_eyes_color').text('');

	var passport_eyes_color = $(passport).find('[name=passport_eyes_color]').val();

	var passport_eyes_color_length = passport_eyes_color.length;

	for (var i = 0; i < passport_eyes_color_length; i++) {

		$(printscreen).find('p.passport_eyes_color').append('<span>' + passport_eyes_color[i]  + '</span>');

	}

	

	/*** PASSPORT AUTORITY ***/

	$(printscreen).find('p.passport_autority').text('');

	var passport_autority = $(passport).find('[name=passport_autority]').val();

	var passport_autority_length = passport_autority.length;

	for (var i = 0; i < passport_autority_length; i++) {

		$(printscreen).find('p.passport_autority').append('<span>' + passport_autority[i]  + '</span>');

	}

	

	/*** PASSPORT CREATION ***/

	$(printscreen).find('p.passport_creation').text('');

	var passport_creation = $(passport).find('[name=passport_expiration_date]').val().split('.');

	passport_creation = passport_creation[0] + '.' + passport_creation[1] + '.' + (parseInt(passport_creation[2])-10).toString().substr(2);

	var passport_creation_length = passport_creation.length;

	for (var i = 0; i < passport_creation_length; i++) {

		$(printscreen).find('p.passport_creation').append('<span>' + passport_creation[i]  + '</span>');

	}

	

	/*** PASSPORT NAME BOTTOM ***/

	$(printscreen).find('p.passport_name_bottom').text('');

	var passport_first_name = $(passport).find('[name=passport_first_name]').val();

	var passport_first_name_length = $(passport).find('[name=passport_first_name]').val().length;

	var passport_last_name = $(passport).find('[name=passport_last_name]').val();

	var passport_last_name_length = $(passport).find('[name=passport_last_name]').val().length;

	for (var i = 0; i < passport_first_name_length; i++) {

		if(passport_first_name[i] == ' ')

		{

			$(printscreen).find('p.passport_name_bottom').append('<span class="break"><</span><span class="break"><</span>');

		}

		else

		{

			$(printscreen).find('p.passport_name_bottom').append('<span>' + passport_first_name[i]  + '</span>');

		}

	}

	$(printscreen).find('p.passport_name_bottom').append('<span class="break"><</span><span class="break"><</span>');

	for (var i = 0; i < passport_last_name_length; i++) {

		if(passport_last_name[i] == ' ')

		{

			$(printscreen).find('p.passport_name_bottom').append('<span class="break"><</span>');

		}

		else

		{

			$(printscreen).find('p.passport_name_bottom').append('<span>' + passport_last_name[i]  + '</span>');

		}

	}

	var name_length = $(printscreen).find('p.passport_name_bottom:first').text().length;

	for (var i = 0; i < (31 - name_length); i++) {

		$(printscreen).find('p.passport_name_bottom').append('<span class="break"><</span>');

	}

	

	/*** PASSPORT CODE BOTTOM ***/

	$(printscreen).find('p.passport_code_bottom').text('');

	var passport_code_bottom = $(passport).find('[name=passport_code]').val();

	var passport_code_bottom_length = $(passport).find('[name=passport_code]').val().length;

	for (var i = 0; i < passport_code_bottom_length; i++) {

		$(printscreen).find('p.passport_code_bottom').append('<span>' + passport_code_bottom[i]  + '</span>');

	}

	

	/*** PASSPORT ROTATION ***/

	var passport_rotation = parseInt($(passport).find('[name=passport_rotation]').val());

	$('#printscreen div').jqrotate(passport_rotation);

}



$(document).ready(function(){

	

	/******************************************************* PASSPORT EDIT ************************************************************/

	$('#owners label .edit').click(function(){

		var label = $(this).parent('label').find('input[type=checkbox]').val();

		$('#owners label').each(function(){

			if($(this).next('#passport').is(':visible') && label != $(this).find('input[type=checkbox]').val())

			{

				$(this).next('#passport').slideUp().next('#printscreen').slideUp();

			}

		})

		$(this).parent('label').next('#passport').slideToggle().next('#printscreen').slideToggle();

		update($(this).parent('label').next('#passport'),$(this).parent('label').next('#passport').next('#printscreen'));

		return false;

	})

	

	/******************************************************** PASSPORT ADD ************************************************************/

	$('a:contains("Add owner")').click(function(){

		$('label.label_example').next('#passport').slideToggle().next('#printscreen').slideToggle();

		$('label input').attr('checked',false);

		update($('label.label_example').next('#passport'),$('label.label_example').next('#passport').next('#printscreen'));

		return false;

	})



	var fonts = '';

	$('[name=passport_signature_font] option').each(function(){

		fonts = fonts + "\n" + '@font-face { font-family: font' + $(this).val() + '; src: url(f/fonts/' + $(this).attr('font') + '); }' + "\n";

	})

	$('body').append('<style>' + fonts + '</style>');

	$('input, select').bind('keyup change',function(){

		$(this).removeAttr('style');

		update($(this).closest('#passport'),$(this).closest('#passport').next('#printscreen'));

	})

	

	$('button[action]').click(function(){

		var passport = $(this).closest('table#passport');

		var printscreen = $(this).closest('table#passport').next('#printscreen');

		

		var save_passport = $(passport).find('input,select').serialize();

		var save_passport_id = $(passport).find('input[name=passport_id]').val();

		var save_passport_quality = $(passport).find('input[name=passport_quality]').val();

		

		

		var skip = 'true';

		$(passport).find('input,select').each(function(){

			if($(this).val() == '')

			{

				$(this).css('border','1px solid red'); skip = 'false';

			}

		})

		

		if($(passport).find('input[name=passport_code]').val().length != 9)

		{

			$(passport).find('input[name=passport_code]').css('border','1px solid red'); skip = 'false';

		}

		

		if($(passport).find('input[name=passport_bottom_code]').val().length != 27)

		{

			$(passport).find('input[name=passport_bottom_code]').css('border','1px solid red'); skip = 'false';

		}

		

		if($(passport).find('input[name=passport_height]').val().length != 3)

		{

			$(passport).find('input[name=passport_height]').css('border','1px solid red'); skip = 'false';

		}

		

		if($(passport).find('input[name=passport_date_of_birth]').val().length != 8)

		{

			$(passport).find('input[name=passport_date_of_birth]').css('border','1px solid red'); skip = 'false';

		}

		

		if($(passport).find('input[name=passport_expiration_date]').val().length != 10)

		{

			$(passport).find('input[name=passport_expiration_date]').css('border','1px solid red'); skip = 'false';

		}

		

		if(skip == 'true')

		{

			$('#p').show();

			/* Print signature agreement AND save fields */

			$('body p.passport_signature_print').css('display','inline-block');

			html2canvas($('body p.passport_signature_print'), { onrendered: function(canvas) {

				$('body p.passport_signature_print').hide();

				$('body p.passport_signature_print').html(canvas);

				var save_passport_signature = canvas.toDataURL().replace(/^data[:]image\/(png|jpg|jpeg)[;]base64,/i, "");

				$.ajax({

					"type": "POST",

					"url": "p_owners.php",

					"data": {

						"save_passport_id": save_passport_id,

						"save_passport_signature": save_passport_signature,

						"save_passport": save_passport

					}

				})

				.always(function(msg) { if(msg != 'done') {alert(msg);}

					else

					{

						/* Print passport signature */

						html2canvas($(printscreen).find('p.passport_signature'), { onrendered: function(canvas) {

							$(printscreen).find('p.passport_signature').html(canvas).jqrotate($(passport).find('[name=passport_signature_rotation]').val());

							

							/* Print passport box */

							html2canvas($(printscreen).find('div'), { onrendered: function(canvas) {

								$(printscreen).find('div').html(canvas);

								

								/* Print passport */

								html2canvas($(printscreen), { onrendered: function(canvas) {

									

									var img = canvas.toDataURL().replace(/^data[:]image\/(png|jpg|jpeg)[;]base64,/i, "");

									var img_length = img.length;

									var img_parts = parseInt(img_length / 3);

									var save_passport_image_1 = img.substr(0, img_parts);

									var save_passport_image_2 = img.substr(img_parts, img_parts);

									var save_passport_image_3 = img.substr((img_parts + img_parts),img_length);

									

									/* Save passport part 1 */

									$.ajax({

										"type": "POST",

										"url": "p_owners.php",

										"data": {

											"save_passport_image_1": save_passport_image_1

										}

									})

									.always(function(msg) { if(msg != 'done') {alert(msg);}

										else

										{

											/* Save passport part 2 */

											$.ajax({

												"type": "POST",

												"url": "p_owners.php",

												"data": {

													"save_passport_image_2": save_passport_image_2

												}

											})

											.always(function(msg) { if(msg != 'done') {alert(msg);}

												else

												{

													/* Save passport part 3 */

													$.ajax({

														"type": "POST",

														"url": "p_owners.php",

														"data": {

															"save_passport_image_3": save_passport_image_3,

															"save_passport_quality": save_passport_quality

														}

													})

													.always(function(msg) { if(msg != 'done') {alert(msg);}

														else

														{

															window.location.replace("?p=owners&done=" + save_passport_id);

														}

													})

												}

											})

										}

									})

								}})

							}})

						}})

					}

				})

			}})

		}

	})

	

	/****************************************************** PASSPORT SEARCH ***********************************************************/

	$("input.search").bind("click paste keyup keydown", function() {

		$('label [type=checkbox]').prop('checked',false);

		passport_select();

		

		var search = $(this);

		var search_val = $(this).val().toLowerCase();

		var results = 'false';

		

		$('label').each(function(){

			if(search_val != '' && $(this).html().toLowerCase().indexOf(search_val) >= 1)

			{

				$(this).next('#passport').next('#printscreen').insertAfter("div.after");

				$(this).next('#passport').insertAfter("div.after");

				$(this).insertAfter("div.after");

				$(this).css('background','#ecffee');

				results = 'true';

			}

		});

		if(results == 'true' || search_val == '')

		{

			$(search).css('border','1px solid grey');

		}

		else

		{

			$(search).css('border','1px solid red');

		}

	});

	

	/****************************************************** PASSPORT SELECT ***********************************************************/

	function passport_select()

	{

		var i = 0;

		$(".confirmation p:last").html("<br />");

		$(".confirmation a.danger").attr("href","index.php?p=owners&do=delete&id=");

			

		$("label").each(function(){

			if($(this).find("[type=checkbox]:checked").length && !$(this).hasClass('label_example'))

			{

				i++;

				$(this).css('background','#21496d');

				$('span',this).css('color','#fff');

				if(i < 10)

				{

					var nr = '&nbsp;&nbsp;' + i;

				}

				else

				{

					var nr = i;

				}

				$(".confirmation p:last").html($(".confirmation p:last").html() + nr + '.&nbsp;&nbsp;' + $("span.name",this).text() + "<br />");

				$(".confirmation a.danger").attr("href",$(".confirmation a.danger").attr("href") + $("input",this).val() + ",");

			}

			else

			{

				$(this).removeAttr('style');

				$('span',this).removeAttr('style');

			}

		});

		

		if(i > 0)

		{

			$("button.delete").removeClass('opacity');

		}

		else

		{

			$("button.delete").addClass('opacity');

			$(".confirmation").slideUp();

		}

		$("button.delete").attr("onClick","delete_list(); return false");

		

		$('table#passport').slideUp(200);

		$('div#printscreen').slideUp(200);

	}

	

	/************************************************* PASSPORT SHOW DELETE LIST ******************************************************/

	function passport_delete()

	{

		var i = 0; $("label").each(function(){ if($(this).find("[type=checkbox]:checked").length) {$(".confirmation").slideDown();} });

	}

	

	$('button.select').click(function() {

		$('[type=checkbox]').prop('checked',true); passport_select(); return false;

	});

	$('button.deselect').click(function() {

		$('[type=checkbox]').prop('checked',false); passport_select(); return false;

	});

	$('button.delete').click(function() {

		passport_delete(); return false;

	});

	$('label').click(function() {

		passport_select();

	});

})

</script>

